/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

public class SourcePrinter {
    private static final String DEFAULT_NEWLINE = System.getProperty("line.separator");
    private StringBuffer _buffer = new StringBuffer();
    private String _indentText;
    private String _currentIndent;
    private String _newLine;

    public SourcePrinter() {
        this("  ");
    }

    public SourcePrinter(String indent) {
        this._indentText = indent;
        this._currentIndent = "";
        this._newLine = DEFAULT_NEWLINE;
    }

    public SourcePrinter decreaseIndent() {
        if (this._currentIndent.length() > 0) {
            int currentLength = this._currentIndent.length();
            int indentTextLength = this._indentText.length();
            this._currentIndent = this._currentIndent.substring(0, currentLength - indentTextLength);
        }
        return this;
    }

    public StringBuffer getBuffer() {
        return this._buffer;
    }

    public int getIndentLevel() {
        if (this._indentText.length() == 0) {
            return 0;
        }
        return this._currentIndent.length() / this._indentText.length();
    }

    public String getIndentString() {
        return this._currentIndent;
    }

    public String getLineDelimeter() {
        return this._newLine;
    }

    public SourcePrinter increaseIndent() {
        this._currentIndent = String.valueOf(this._currentIndent) + this._indentText;
        return this;
    }

    public SourcePrinter print(char c) {
        this._buffer.append(c);
        return this;
    }

    public SourcePrinter print(String text) {
        this._buffer.append(text);
        return this;
    }

    public SourcePrinter print(Object object) {
        this._buffer.append(object);
        return this;
    }

    public SourcePrinter printIndent() {
        this._buffer.append(this._currentIndent);
        return this;
    }

    public SourcePrinter println() {
        this.println("");
        return this;
    }

    public SourcePrinter println(char text) {
        this._buffer.append(text).append(this._newLine);
        return this;
    }

    public SourcePrinter println(String text) {
        this._buffer.append(text).append(this._newLine);
        return this;
    }

    public SourcePrinter printlnWithIndent(char text) {
        this._buffer.append(this._currentIndent).append(text).append(this._newLine);
        return this;
    }

    public SourcePrinter printlnWithIndent(String text) {
        this._buffer.append(this._currentIndent).append(text).append(this._newLine);
        return this;
    }

    public SourcePrinter printWithIndent(char text) {
        this._buffer.append(this._currentIndent).append(text);
        return this;
    }

    public SourcePrinter printWithIndent(String text) {
        this._buffer.append(this._currentIndent).append(text);
        return this;
    }

    public void setLineDelimeter(String separator) {
        this._newLine = separator;
    }

    public String toString() {
        return this._buffer.toString();
    }
}

